package com.ejie.aa17a.informes;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.aa17a.model.Aa17aDatoHistorico;
import com.ejie.aa17a.model.Aa17aDatoHorario;
import com.ejie.aa17a.model.Aa17aInformeFiltro;
import com.ejie.aa17a.utilidades.Aa17aConstantes;
import com.ejie.aa17a.utilidades.Aa17aExcelUtil;
import com.ejie.aa17a.utilidades.Aa17aFuncionesComunes;

/**
 * 
 * @author francisco.galvez
 * 
 */
public class Aa17aInformesExcel {

	private Integer rowNum;
	private HSSFSheet sheet;
	private Locale locale = LocaleContextHolder.getLocale();
	private HSSFWorkbook wb;
	private HSSFCellStyle styleCelda;
	private HSSFCellStyle styleTitulo;
	private HSSFCellStyle styleCabecera;
	private HSSFCellStyle styleCeldaFiltro;
	private HSSFCellStyle styleCeldaTitulo;

	private MessageSource excelMessageSource;

	/**
	 * 
	 * @param excelMessageSource
	 *            MessageSource
	 */
	public Aa17aInformesExcel(MessageSource excelMessageSource) {
		this.excelMessageSource = excelMessageSource;
	}

	/**
	 * @param excelMessageSource
	 *            the excelMessageSource to set
	 */
	public void setExcelMessageSource(MessageSource excelMessageSource) {
		this.excelMessageSource = excelMessageSource;
	}

	/**
	 * @param pwb
	 *            HSSFWorkbook
	 * @param listDatosHorarios
	 *            List<Aa17aDatoHorario>
	 * @param informeFiltro
	 *            Aa17aInformeFiltro
	 * @exception Exception
	 *                e
	 */
	public void informeDatosHorarios(HSSFWorkbook pwb, List<Aa17aDatoHorario> listDatosHorarios, Aa17aInformeFiltro informeFiltro) throws Exception {

		this.wb = pwb;

		//defino los styles para las celdas
		this.definirStylesCeldas();

		//creo la hoja del excel
		this.sheet = this.wb.createSheet(this.getLiteral("informe.datosHorarios"));

		//añado la cabecera del informe
		this.rowNum = Aa17aConstantes.MAGIC_NUMBER_0;
		this.dibujarCabeceraInforme();

		//añado el título al informe
		this.rowNum += Aa17aConstantes.MAGIC_NUMBER_3;
		this.tituloInforme(this.getLiteral("informe.datosHorarios.titulo"), this.rowNum, Aa17aConstantes.MAGIC_NUMBER_1, Aa17aConstantes.MAGIC_NUMBER_24);

		//añado los criterios de búsqueda seleccionados para sacar el informe
		this.rowNum++;
		this.dibujarCriteriosBusqueda(informeFiltro, Aa17aConstantes.MAGIC_NUMBER_1, Aa17aConstantes.MAGIC_NUMBER_24);

		this.rowNum += 2; //dejo siempre una fila de separación entre los criterios de búsqueda y la cabecera de los datos

		this.celdaCaptionCabecera(this.getLiteral("informe.datosHorarios.horasGMT"), Aa17aConstantes.MAGIC_NUMBER_1, Aa17aConstantes.MAGIC_NUMBER_24);

		this.rowNum++;

		//fila para la cabecera del listado
		HSSFRow rowCabecera = this.sheet.createRow(this.rowNum);
		Integer colNum = 0;
		this.celdaCabecera(rowCabecera, colNum++, this.getLiteral("informe.parametro"), Aa17aConstantes.MAGIC_NUMBER_4);
		this.celdaCabecera(rowCabecera, colNum++, "1", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "2", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "3", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "4", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "5", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "6", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "7", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "8", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "9", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "10", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "11", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "12", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "13", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "14", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "15", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "16", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "17", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "18", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "19", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "20", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "21", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "22", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "23", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "24", Aa17aConstantes.MAGIC_NUMBER_2);

		for (Aa17aDatoHorario datoHorario : listDatosHorarios) {
			colNum = 0;
			this.rowNum++;

			String nombreContaminante = datoHorario.getContaminante().getNombreContaminante() + " (" + datoHorario.getContaminante().getUnidadMedida() + ")";

			HSSFRow rowRegistro = this.sheet.createRow(this.rowNum);
			this.celdaRegistro(rowRegistro, colNum++, nombreContaminante);
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora01());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora02());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora03());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora04());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora05());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora06());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora07());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora08());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora09());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora10());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora11());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora12());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora13());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora14());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora15());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora16());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora17());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora18());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora19());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora20());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora21());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora22());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora23());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora24());

		}

	}

	/**
	 * @param pwb
	 *            HSSFWorkbook
	 * @param listDatosHorarios
	 *            List<Aa17aDatoHorario>
	 * @param informeFiltro
	 *            Aa17aInformeFiltro
	 * @exception Exception
	 *                e
	 */
	public void informeDatosHistoricoHorarios(HSSFWorkbook pwb, List<Aa17aDatoHorario> listDatosHorarios, Aa17aInformeFiltro informeFiltro) throws Exception {

		this.wb = pwb;

		//defino los styles para las celdas
		this.definirStylesCeldas();

		//Defino un estilo por defecto para las celdas
		this.styleCelda = this.wb.createCellStyle();

		//creo la hoja del excel
		this.sheet = this.wb.createSheet(this.getLiteral("informe.datosHorarios.titulo"));

		//añado la cabecera del informe
		this.rowNum = Aa17aConstantes.MAGIC_NUMBER_0;
		this.dibujarCabeceraInforme();

		//añado el título al informe
		this.rowNum += Aa17aConstantes.MAGIC_NUMBER_3;
		this.tituloInforme(this.getLiteral("informe.datosHorarios.titulo"), this.rowNum, Aa17aConstantes.MAGIC_NUMBER_1, Aa17aConstantes.MAGIC_NUMBER_25);

		//añado los criterios de búsqueda seleccionados para sacar el informe
		this.rowNum++;
		this.dibujarCriteriosBusqueda(informeFiltro, Aa17aConstantes.MAGIC_NUMBER_1, Aa17aConstantes.MAGIC_NUMBER_25);

		this.rowNum += 2; //dejo siempre una fila de separación entre los criterios de búsqueda y la cabecera de los datos

		this.celdaCaptionCabecera("HORAS GMT", Aa17aConstantes.MAGIC_NUMBER_2, Aa17aConstantes.MAGIC_NUMBER_25);

		this.rowNum++;

		//fila para la cabecera del listado
		HSSFRow rowCabecera = this.sheet.createRow(this.rowNum);
		Integer colNum = 0;
		this.celdaCabecera(rowCabecera, colNum++, this.getLiteral("informe.parametro"), Aa17aConstantes.MAGIC_NUMBER_4);
		this.celdaCabecera(rowCabecera, colNum++, this.getLiteral("informe.fecha"), Aa17aConstantes.MAGIC_NUMBER_4);
		this.celdaCabecera(rowCabecera, colNum++, "1", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "2", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "3", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "4", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "5", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "6", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "7", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "8", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "9", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "10", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "11", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "12", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "13", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "14", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "15", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "16", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "17", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "18", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "19", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "20", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "21", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "22", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "23", Aa17aConstantes.MAGIC_NUMBER_2);
		this.celdaCabecera(rowCabecera, colNum++, "24", Aa17aConstantes.MAGIC_NUMBER_2);

		for (Aa17aDatoHorario datoHorario : listDatosHorarios) {
			colNum = 0;
			this.rowNum++;

			String nombreContaminante = datoHorario.getContaminante().getNombreContaminante().toString() + " (" + datoHorario.getContaminante().getUnidadMedida().toString() + ")";

			HSSFRow rowRegistro = this.sheet.createRow(this.rowNum);
			this.celdaRegistro(rowRegistro, colNum++, nombreContaminante);
			this.celdaRegistro(rowRegistro, colNum++, Aa17aFuncionesComunes.formatearFecha(datoHorario.getFechaDato()));
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora01());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora02());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora03());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora04());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora05());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora06());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora07());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora08());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora09());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora10());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora11());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora12());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora13());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora14());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora15());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora16());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora17());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora18());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora19());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora20());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora21());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora22());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora23());
			this.celdaRegistro(rowRegistro, colNum++, datoHorario.getValorHora24());

		}

	}

	/**
	 * @param pwb
	 *            HSSFWorkbook
	 * @param listDatosHistorico
	 *            List<Aa17aDatoHistorico>
	 * @param informeFiltro
	 *            Aa17aInformeFiltro
	 * @exception Exception
	 *                e
	 */
	public void informeDatosHistoricoDiarios(HSSFWorkbook pwb, List<Aa17aDatoHistorico> listDatosHistorico, Aa17aInformeFiltro informeFiltro) throws Exception {

		this.wb = pwb;

		//defino los styles para las celdas
		this.definirStylesCeldas();

		//Defino un estilo por defecto para las celdas
		this.styleCelda = this.wb.createCellStyle();

		//creo la hoja del excel
		this.sheet = this.wb.createSheet(this.getLiteral("informe.datosHitoricos.titulo"));

		//añado la cabecera del informe
		this.rowNum = Aa17aConstantes.MAGIC_NUMBER_0;
		this.dibujarCabeceraInforme();

		//añado el título al informe
		this.rowNum += Aa17aConstantes.MAGIC_NUMBER_3;
		this.tituloInforme(this.getLiteral("informe.datosHitoricos.titulo"), this.rowNum, Aa17aConstantes.MAGIC_NUMBER_1, Aa17aConstantes.MAGIC_NUMBER_11);

		//añado los criterios de búsqueda seleccionados para sacar el informe
		this.rowNum++;
		this.dibujarCriteriosBusqueda(informeFiltro, Aa17aConstantes.MAGIC_NUMBER_1, Aa17aConstantes.MAGIC_NUMBER_11);

		this.rowNum += 2; //dejo siempre una fila de separación entre los criterios de búsqueda y la cabecera de los datos

		//fila para la cabecera del listado
		HSSFRow rowCabecera = this.sheet.createRow(this.rowNum);
		Integer colNum = Aa17aConstantes.MAGIC_NUMBER_5;
		this.celdaCabecera(rowCabecera, colNum++, this.getLiteral("informe.parametro"), Aa17aConstantes.MAGIC_NUMBER_4);
		this.celdaCabecera(rowCabecera, colNum++, this.getLiteral("informe.fecha"), Aa17aConstantes.MAGIC_NUMBER_4);
		this.celdaCabecera(rowCabecera, colNum++, this.getLiteral("informe.datosHitoricos.valor"), Aa17aConstantes.MAGIC_NUMBER_2);

		for (Aa17aDatoHistorico datoHistorico : listDatosHistorico) {
			colNum = Aa17aConstantes.MAGIC_NUMBER_5;
			this.rowNum++;

			String nombreContaminante = datoHistorico.getContaminante().getNombreContaminante().toString() + " (" + datoHistorico.getContaminante().getUnidadMedida().toString() + ")";

			HSSFRow rowRegistro = this.sheet.createRow(this.rowNum);
			this.celdaRegistro(rowRegistro, colNum++, nombreContaminante);
			this.celdaRegistro(rowRegistro, colNum++, Aa17aFuncionesComunes.formatearFecha(datoHistorico.getFechaDato()));
			this.celdaRegistro(rowRegistro, colNum++, datoHistorico.getValorDiario());

		}

	}

	/**
	 * Función para generar el título del informe en el excel
	 * 
	 * @param strTitulo
	 *            String
	 * @param numRow
	 *            Integer
	 * @param colSpanIni
	 *            Integer
	 * @param colSpanFin
	 *            Integer
	 * 
	 * @throws Exception
	 *             e
	 */
	private void tituloInforme(String strTitulo, Integer numRow, Integer colSpanIni, Integer colSpanFin) throws Exception {

		HSSFRow row = this.sheet.createRow(this.rowNum);

		HSSFCell cell = row.createCell(colSpanIni);
		this.sheet.addMergedRegion(new CellRangeAddress(numRow, numRow, colSpanIni, colSpanFin));
		cell.setCellValue(strTitulo);
		cell.setCellStyle(this.styleTitulo);
	}

	/**
	 * Método para generar una celda sobre la cabecera de un informe a modo de
	 * caption.
	 * 
	 * @param textoCol
	 *            String
	 * 
	 * @param colSpanIni
	 *            Integer
	 * 
	 * @param colSpanFin
	 *            Integer
	 */
	private void celdaCaptionCabecera(String textoCol, Integer colSpanIni, Integer colSpanFin) {
		HSSFRow row = this.sheet.createRow(this.rowNum);

		HSSFCell cell = row.createCell(colSpanIni);
		this.sheet.addMergedRegion(new CellRangeAddress(this.rowNum, this.rowNum, colSpanIni, colSpanFin));
		cell.setCellValue(textoCol);
		cell.setCellStyle(this.styleCabecera);

	}

	/**
	 * Método para generar una celda de la cabecera de un informe. En este
	 * método, al no pasarse como parámetro el estilo de la celda, se crea una
	 * por defecto
	 * 
	 * @param row
	 *            HSSFRow
	 * @param indexCol
	 *            Integer
	 * @param textoCol
	 *            String
	 * @param anchoCol
	 *            Integer
	 */
	private void celdaCabecera(HSSFRow row, Integer indexCol, String textoCol, Integer anchoCol) {

		HSSFFont fontCabecera = this.wb.createFont();
		fontCabecera.setBoldweight(Font.BOLDWEIGHT_BOLD);
		fontCabecera.setColor(HSSFColor.WHITE.index);
		//fontCabecera.setFontHeight(Y96bConstantes.MAGIC_NUMBER_200.shortValue());
		this.styleCabecera.setFont(fontCabecera);
		this.styleCabecera.setWrapText(true); // Para poder usar varias líneas en una celda
		this.styleCabecera.setFillForegroundColor(this.getColor(Aa17aConstantes.COLOR_CABECERA_INFORME_R, Aa17aConstantes.COLOR_CABECERA_INFORME_G, Aa17aConstantes.COLOR_CABECERA_INFORME_B));
		this.styleCabecera = Aa17aExcelUtil.celdaBordesTipo(this.styleCabecera, HSSFCellStyle.BORDER_THIN);
		this.styleCabecera = Aa17aExcelUtil.celdaBordesColor(this.styleCabecera, HSSFColor.BLACK.index);
		this.styleCabecera.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		this.styleCabecera.setAlignment(HSSFCellStyle.ALIGN_CENTER_SELECTION);

		this.celdaCabecera(row, indexCol, textoCol, anchoCol, this.styleCabecera);
	}

	/**
	 * Método para generar una celda de la cabecera del informe
	 * 
	 * @param row
	 *            HSSFRow
	 * @param indexCol
	 *            Integer
	 * @param textoCol
	 *            String
	 * @param anchoCol
	 *            Integer
	 * @param pStyleCabecera
	 *            HSSFCellStyle
	 */
	private void celdaCabecera(HSSFRow row, Integer indexCol, String textoCol, Integer anchoCol, HSSFCellStyle pStyleCabecera) {

		HSSFCell cell = row.createCell(indexCol);
		cell.setCellValue(textoCol);
		cell.setCellStyle(pStyleCabecera);
		//calculo el ancho de la cabecera
		Integer ancho = (int) ((Aa17aConstantes.MAGIC_NUMBER_50 * anchoCol) / ((double) Aa17aConstantes.MAGIC_NUMBER_1 / Aa17aConstantes.MAGIC_NUMBER_20));
		this.sheet.setColumnWidth(indexCol, ancho); // Da un tamaño concreto a la columna

	}

	/**
	 * Método para escribir un texto en una celda. En este método no es
	 * encesario pasar como parámetro el estilo de la celda
	 * 
	 * @param row
	 *            HSSFRow
	 * @param indexCol
	 *            Integer
	 * @param textoCol
	 *            String
	 */
	private void celdaRegistro(HSSFRow row, Integer indexCol, Object textoCol) {

		this.celdaRegistro(row, indexCol, textoCol, this.styleCelda);
	}

	/**
	 * 
	 * @param row
	 *            HSSFRow
	 * @param indexCol
	 *            Integer
	 * @param textoCelda
	 *            String
	 * @param pStyleCelda
	 *            HSSFCellStyle
	 */
	private void celdaRegistro(HSSFRow row, Integer indexCol, Object textoCelda, HSSFCellStyle pStyleCelda) {

		HSSFCell cell = row.createCell(indexCol);

		if (textoCelda instanceof String) {
			cell.setCellValue((String) textoCelda);
			cell.setCellType(HSSFCell.CELL_TYPE_STRING);
		}

		if (textoCelda instanceof Integer) {
			cell.setCellValue((Integer) textoCelda);
			cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
		}

		if (textoCelda instanceof Long) {
			cell.setCellValue((Long) textoCelda);
			cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
		}

		if (textoCelda instanceof Float) {
			cell.setCellValue((Float) textoCelda);
			cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
			//formateo la celda para que tenga un máximo de 2 decimales
			HSSFDataFormat format = this.wb.createDataFormat();
			pStyleCelda.setDataFormat(format.getFormat("0.00"));
		}

		if (textoCelda instanceof Double) {
			cell.setCellValue((Double) textoCelda);
			cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
			//formateo la celda para que tenga un máximo de 2 decimales
			HSSFDataFormat format = this.wb.createDataFormat();
			pStyleCelda.setDataFormat(format.getFormat("0.00"));
		}

		if (textoCelda instanceof BigDecimal) {
			cell.setCellValue((Double) ((BigDecimal) textoCelda).doubleValue());
			cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
			//formateo la celda para que tenga un máximo de 2 decimales
			HSSFDataFormat format = this.wb.createDataFormat();
			pStyleCelda.setDataFormat(format.getFormat("0.00"));
		}

		if (textoCelda instanceof Short) {
			cell.setCellValue((Short) textoCelda);
			cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
		}

		if (textoCelda instanceof Date) {
			cell.setCellValue((Date) textoCelda);
			cell.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
		}

		if (pStyleCelda != null) {
			cell.setCellStyle(pStyleCelda);
		}
	}

	/**
	 * Método para obtener un color RGB
	 * 
	 * @param red
	 *            Integer
	 * @param green
	 *            Integer
	 * @param blue
	 *            Integer
	 * @return Short
	 */
	private Short getColor(Integer red, Integer green, Integer blue) {
		HSSFPalette palette = this.wb.getCustomPalette();
		HSSFColor myColor = palette.findSimilarColor(red, green, blue);
		return myColor.getIndex();
	}

	/**
	 * 
	 * @throws Exception
	 *             e
	 */
	private void dibujarCabeceraInforme() throws Exception {

		//inserto la imagen del logo del GV
		File img = new File(Aa17aConstantes.INFORME_IMAGEN_LOGO_GV);
		HSSFPatriarch patriarch = this.sheet.createDrawingPatriarch();
		HSSFClientAnchor anchor;
		anchor = new HSSFClientAnchor(0, 0, 0, 0, Aa17aConstantes.MAGIC_NUMBER_0.shortValue(), this.rowNum, Aa17aConstantes.MAGIC_NUMBER_2.shortValue(), Aa17aConstantes.MAGIC_NUMBER_3);
		anchor.setAnchorType(Aa17aConstantes.MAGIC_NUMBER_0);
		patriarch.createPicture(anchor, this.loadPicture(img));

		//Titulo de la cabecera del informe
		HSSFRow row = this.sheet.createRow(this.rowNum);
		HSSFCell cell = row.createCell(Aa17aConstantes.MAGIC_NUMBER_3);
		this.sheet.addMergedRegion(new CellRangeAddress(this.rowNum, this.rowNum, Aa17aConstantes.MAGIC_NUMBER_3, Aa17aConstantes.MAGIC_NUMBER_11));
		cell.setCellValue(this.getLiteral("informe.titulo"));
		cell.setCellStyle(this.styleTitulo);

		this.rowNum++;

		//Titulo de la cabecera del informe
		HSSFRow rowUrl = this.sheet.createRow(this.rowNum);
		HSSFCell cellUrl = rowUrl.createCell(Aa17aConstantes.MAGIC_NUMBER_3);
		this.sheet.addMergedRegion(new CellRangeAddress(this.rowNum, this.rowNum, Aa17aConstantes.MAGIC_NUMBER_3, Aa17aConstantes.MAGIC_NUMBER_11));
		Hyperlink link = new HSSFHyperlink(HSSFHyperlink.LINK_URL);
		link.setAddress("http://www.ingurumena.ejgv.euskadi.net");
		cellUrl.setHyperlink(link);
		cellUrl.setCellValue("www.ingurumena.ejgv.euskadi.net");
		cellUrl.setCellStyle(this.styleTitulo);

	}

	/**
	 * Metodo que permite insertar imagenes a el excel
	 * 
	 * @param path
	 *            File
	 * @return int
	 * 
	 * @throws Exception
	 *             e
	 */
	private int loadPicture(File path) throws Exception {
		int pictureIndex;
		FileInputStream fis = null;
		ByteArrayOutputStream bos = null;
		try {
			// read in the image file
			fis = new FileInputStream(path);
			bos = new ByteArrayOutputStream();
			int c;
			// copy the image bytes into the ByteArrayOutputStream
			while ((c = fis.read()) != -1) {
				bos.write(c);
			}
			// add the image bytes to the workbook
			pictureIndex = this.wb.addPicture(bos.toByteArray(), HSSFWorkbook.PICTURE_TYPE_PNG);

		} finally {
			if (fis != null) {
				fis.close();
			}

			if (bos != null) {
				bos.close();
			}
		}
		return pictureIndex;
	}

	/**
	 * Función que dibuja los criterios de búsqueda seleccionados para generar
	 * el informe
	 * 
	 * @param informeFiltro
	 *            Y96bInformeFiltro
	 * @param numColSpanIni
	 *            Integer
	 * @param numColSpanFin
	 *            Integer
	 */
	private void dibujarCriteriosBusqueda(Aa17aInformeFiltro informeFiltro, Integer numColSpanIni, Integer numColSpanFin) {

		HSSFRow rowCriterios = null;
		HSSFCell celdaCriterios = null;

		//espacio de separación superior
		rowCriterios = this.sheet.createRow(this.rowNum);
		celdaCriterios = rowCriterios.createCell(numColSpanIni);
		this.sheet.addMergedRegion(new CellRangeAddress(this.rowNum, this.rowNum, numColSpanIni, numColSpanFin));
		celdaCriterios.setCellStyle(this.styleCeldaTitulo);

		//Estacion
		if (informeFiltro.getNombreEstacion() != null) {
			this.rowNum++;
			rowCriterios = this.sheet.createRow(this.rowNum);
			celdaCriterios = rowCriterios.createCell(numColSpanIni);
			this.sheet.addMergedRegion(new CellRangeAddress(this.rowNum, this.rowNum, numColSpanIni, numColSpanFin));

			StringBuilder cadena = new StringBuilder();
			cadena.append(this.getLiteral("informe.estacion"));
			cadena.append(": ");
			cadena.append(informeFiltro.getNombreEstacion());
			celdaCriterios.setCellValue(cadena.toString());
			celdaCriterios.setCellStyle(this.styleCeldaFiltro);
		}

		//contaminantes
		if (informeFiltro.getListaNombresContaminantes() != null && informeFiltro.getListaNombresContaminantes().size() > 0) {

			this.rowNum++;
			rowCriterios = this.sheet.createRow(this.rowNum);
			celdaCriterios = rowCriterios.createCell(numColSpanIni);
			this.sheet.addMergedRegion(new CellRangeAddress(this.rowNum, this.rowNum, numColSpanIni, numColSpanFin));

			StringBuilder cadena = new StringBuilder();
			cadena.append(this.getLiteral("informe.parametros"));
			cadena.append(": ");

			for (String nombre : informeFiltro.getListaNombresContaminantes()) {
				cadena.append(" - ");
				cadena.append(nombre);
			}

			celdaCriterios.setCellValue(cadena.toString());
			celdaCriterios.setCellStyle(this.styleCeldaFiltro);

		}

		//Fecha
		if (informeFiltro.getFecha() != null) {

			this.rowNum++;
			rowCriterios = this.sheet.createRow(this.rowNum);
			celdaCriterios = rowCriterios.createCell(numColSpanIni);
			this.sheet.addMergedRegion(new CellRangeAddress(this.rowNum, this.rowNum, numColSpanIni, numColSpanFin));

			StringBuilder cadena = new StringBuilder();
			cadena.append(this.getLiteral("informe.fecha"));
			cadena.append(": ");
			cadena.append(Aa17aFuncionesComunes.formatearFecha(informeFiltro.getFecha(), this.locale));
			celdaCriterios.setCellValue(cadena.toString());
			celdaCriterios.setCellStyle(this.styleCeldaFiltro);
		}

		//Fecha Desde y Fecha Hasta
		if (informeFiltro.getFechaDesde() != null || informeFiltro.getFechaHasta() != null) {
			this.rowNum++;
			rowCriterios = this.sheet.createRow(this.rowNum);
			celdaCriterios = rowCriterios.createCell(numColSpanIni);
			this.sheet.addMergedRegion(new CellRangeAddress(this.rowNum, this.rowNum, numColSpanIni, numColSpanFin));

			StringBuilder cadena = new StringBuilder();
			cadena.append(this.getLiteral("informe.fecha"));
			cadena.append(": ");

			if (informeFiltro.getFechaDesde() != null) {
				cadena.append(Aa17aFuncionesComunes.formatearFecha(informeFiltro.getFechaDesde(), this.locale));
				cadena.append(" - ");
			}
			if (informeFiltro.getFechaHasta() != null) {
				cadena.append(Aa17aFuncionesComunes.formatearFecha(informeFiltro.getFechaHasta(), this.locale));
			}
			celdaCriterios.setCellValue(cadena.toString());
			celdaCriterios.setCellStyle(this.styleCeldaFiltro);
		}

		this.rowNum++;
		//espacio de separacion inferior
		rowCriterios = this.sheet.createRow(this.rowNum);
		celdaCriterios = rowCriterios.createCell(numColSpanIni);
		this.sheet.addMergedRegion(new CellRangeAddress(this.rowNum, this.rowNum, numColSpanIni, numColSpanFin));
		celdaCriterios.setCellStyle(this.styleCeldaFiltro);

	}

	/**
	 * 
	 * @param key
	 *            String
	 * @return String
	 */
	private String getLiteral(String key) {
		return this.excelMessageSource.getMessage(key, null, this.locale);
	}

	/**
	 * Define los styles por defecto del informe
	 */
	private void definirStylesCeldas() {

		//Defino un estilo por defecto para las celdas
		this.styleCelda = this.wb.createCellStyle();
		this.styleCelda.setWrapText(true); // Para poder usar varias líneas en una celda
		this.styleCelda.setFillForegroundColor(HSSFColor.WHITE.index);
		this.styleCelda = Aa17aExcelUtil.celdaBordesTipo(this.styleCelda, HSSFCellStyle.BORDER_THIN);
		this.styleCelda = Aa17aExcelUtil.celdaBordesColor(this.styleCelda, HSSFColor.BLACK.index);
		this.styleCelda.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
		this.styleCelda.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);

		//Defino el estilo para la cabecera
		this.styleTitulo = this.wb.createCellStyle();
		HSSFFont fontTitulo = this.wb.createFont();
		fontTitulo.setBoldweight(Font.BOLDWEIGHT_BOLD);
		fontTitulo.setColor(HSSFColor.WHITE.index);
		this.styleTitulo.setFont(fontTitulo);
		this.styleTitulo.setWrapText(true); // Para poder usar varias líneas en una celda
		this.styleTitulo.setFillForegroundColor(this.getColor(Aa17aConstantes.COLOR_CABECERA_INFORME_R, Aa17aConstantes.COLOR_CABECERA_INFORME_G, Aa17aConstantes.COLOR_CABECERA_INFORME_B));
		this.styleTitulo.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		this.styleTitulo.setAlignment(HSSFCellStyle.ALIGN_CENTER_SELECTION);

		//Defino el estilo para la cabecera
		this.styleCabecera = this.wb.createCellStyle();
		HSSFFont fontCabecera = this.wb.createFont();
		fontCabecera.setBoldweight(Font.BOLDWEIGHT_BOLD);
		fontCabecera.setColor(HSSFColor.WHITE.index);

		this.styleCabecera.setFont(fontCabecera);
		this.styleCabecera.setWrapText(true); // Para poder usar varias líneas en una celda
		this.styleCabecera.setFillForegroundColor(this.getColor(Aa17aConstantes.COLOR_CABECERA_INFORME_R, Aa17aConstantes.COLOR_CABECERA_INFORME_G, Aa17aConstantes.COLOR_CABECERA_INFORME_B));
		this.styleCabecera = Aa17aExcelUtil.celdaBordesTipo(this.styleCabecera, HSSFCellStyle.BORDER_THIN);
		this.styleCabecera = Aa17aExcelUtil.celdaBordesColor(this.styleCabecera, HSSFColor.BLACK.index);
		this.styleCabecera.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		this.styleCabecera.setAlignment(HSSFCellStyle.ALIGN_CENTER_SELECTION);

		//defino el estilo para el titulo del informe
		this.styleCeldaTitulo = this.wb.createCellStyle();
		this.styleCeldaTitulo.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
		this.styleCeldaTitulo.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);

		//defino el estilo para las filas de los criterios de búsqueda
		this.styleCeldaFiltro = this.wb.createCellStyle();
		this.styleCeldaFiltro.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
		this.styleCeldaFiltro.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		HSSFFont fontCelda = this.wb.createFont();
		fontCelda.setBoldweight(Font.BOLDWEIGHT_BOLD);
		this.styleCeldaFiltro.setFont(fontCelda);

	}

}